require( "quest/m3_signatures/convout.lua" );
combine_speech_tables();

flo_anim_table =
{
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talks",
	"anim/flo/talkse",
	"anim/flo/walke",
	"anim/flo/walkn",
	"anim/flo/walkne",
	"anim/flo/walks",
	"anim/flo/walkse",
};

flo_spec =
{
	name = "FLO";
	halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);	-- enable ground-based scaling
		actor:AddFlag(AFLAG.AFLAG_NO_GROUND_CLICKS);
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:JumpToNamedPoint("flo");
		actor:Face(DIR.E);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(flo_speed);
		actor:SetMode(MODE.CUTSCENE);
		
		
		actor:FaceNow(DIR.W);
		lastScene = game:GetLastScene();
		
		actor:JumpToNamedPoint("exit_walkto");
		actor:WalkTo("flo_walkto");
		wait_walkto();
		run_super_conversation(actor, "conv_on_phone");
		
		game:Set("first_time_signatures", 1);
		
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
	on_arrive = function(flo, button)
		if ( game:Get( "clicked_on_phone" ) ~= 1 ) then
			flo:StartProc(hang_up);
		elseif game:Get( "called_colin" ) > 0 and game:Get( "got_permit_signed" ) < 1 then
			if game:Get("given_colin_permit") < 1 then 
				convproc("FLO", "quip_signatures_flo_D");
			elseif game:Get( "found_orange_pen" ) < 1 then 
				flo:StartProc(where_pen);
			end
		elseif ( game:Get( "got_permit_signed" ) == 1 ) then
			flo:StartProc(outta_here);
		else
			convproc("FLO", "quip_bigcorp_music");
		end
	end;
	
	on_use_inv = function(item, flo, flo2)
		flo_inv_generic(flo, item);
		return RESPONSE.INV_HANDLED;
	end;
};

function outta_here(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_signatures_flo_C");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function where_pen(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_signatures_flo_B");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function hang_up(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_signatures_flo_A");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function colin_on_phone(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_on_phone");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function colin_ignores(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_colin_ignores");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function another_way(flo)
	flo:SetMode(MODE.CUTSCENE);	
	if ( game:Get( "colin_clicks" ) == 1 ) then
		run_super_conversation(flo, "conv_colin_ignores_A");
	else
		local col3 = fmod( game:Get( "colin_clicks" ), 3 );
		if ( col3 == 0 ) then
			run_super_conversation(flo, "conv_colin_ignores_B");
		elseif ( col3 == 1 ) then
			run_super_conversation(flo, "conv_colin_ignores_C");
		else
			run_super_conversation(flo, "conv_colin_ignores_D");
		end
	end
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function colin_still_talking(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_still_talking");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function already_called(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_already_called");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function flo_phone_start(flo)
	flo:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	flo:DumpAnimFile("anim/flo/talkse");
	flo:DumpAnimFile("anim/flo/standse");
	flo:LoadAnimFile("anim/flo/phonese");
	flo:SetScaleX(-1);
	flo:PlayAnim("LiftPhone");
	wait_anim();
	
	flo:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	flo:SetScaleX(1);
	flo:PlayAnim("DoStandSE");
	flo:FaceNow(DIR.E);
	flo:FaceNow(DIR.W);
end

function flo_phone_end(flo)
	flo:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	flo:SetScaleX(-1);
	flo:PlayAnim("LowerPhone");
	wait_anim();
	
	flo:DumpAnimFile("anim/flo/phonese");
	flo:LoadAnimFile("anim/flo/talkse");
	flo:LoadAnimFile("anim/flo/standse");	
	
	flo:ClearFlag(AFLAG.AFLAG_SPECIAL_ANIM);
	flo:SetScaleX(1);
	flo:PlayAnim("DoStandSE");
	flo:FaceNow(DIR.E);
	flo:FaceNow(DIR.W);
end

function should_call(flo)
	game:SetString("purse_level", "level_three");	

	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_should_call");
	scene:ChainToSubScene("purse");
	wait_subscene();
	raise_hud();
	
	if game:Get("found_phoneSig") == 1 then
		game:Set( "called_colin", 1 );
		
		flo_phone_start(flo);
		sfx:PlaySFX("audio/sfx/big_phone");
		run_super_conversation(flo, "conv_call_colin");
		flo_phone_end(flo);
		
		game:Set( "found_phoneSig" , 2);
	end
	flo:SetMode(MODE.FOLLOWCLICKS);
	
end

function call_colin(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo_phone_start(flo);
	run_super_conversation(flo, "conv_call_colin");
	flo_phone_end(flo);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function not_again(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_not_again");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function no_pen_no_sign(flo)
	flo:SetMode(MODE.CUTSCENE);
	game:Set( "given_colin_permit", 1 );
	BAG_INV:RemoveInventory("permit");
	scene:Spawn(permit_spec);
	sfx:PlaySFX("audio/sfx/cake_drop");
	flo_phone_start(flo);
	run_super_conversation(flo, "conv_need_pen");
	flo_phone_end(flo);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function signed_need_stamp(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo_phone_start(flo);
	run_super_conversation(flo, "conv_got_pen");
	flo_phone_end(flo);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function searching(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo_phone_start(flo);
	run_super_conversation(flo, "conv_still_need_pen");
	flo_phone_end(flo);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function great_view(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_signatures_view");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function talk_to_colin(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	flo:FaceActor(colin);
	
	--stuff
	
	flo:Face(DIR.SE);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

colin_spec = 
{
	name = "COLIN";
	halo = "quest/objects/colin";
	gfx = { anim = "anim/colin/stand" };
	
	command = function(actor)
		prepare_actor_text(actor, colin_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);		
		actor:FaceNow(DIR.W);
		--actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(colin_speed);
		actor:SetDepthValue( 426 );
		actor:JumpToNamedPoint("colin");
	end;
	
	on_arrive = function(flo, colin)
		if ( game:Get( "got_permit_signed" ) == 1 ) then
			flo:StartProc(not_again);
		elseif ( game:Get( "given_colin_permit" ) == 1 ) then
			flo:StartProc(searching);
		elseif ( game:Get( "called_colin" ) > 0 ) then
			flo:StartProc(call_colin);
		elseif ( game:Get( "talk_at_colin_1" ) == 1 ) then
			game:Set( "colin_clicks", game:Get( "colin_clicks" ) + 1 );
			flo:StartProc(another_way);
		else
			flo:StartProc(colin_ignores);
			game:Set( "talk_at_colin_1", 1 );
		end
	end;
	
	on_use_inv = function(item, flo, colin)			
		if ( game:Get( "got_permit_signed" )  ~= 1 ) then		
			if item == "orange_pen" then
				if game:Get( "called_colin" ) > 0 then
					if game:Get( "given_colin_permit" ) == 1 then
						BAG_INV:RemoveInventory( "orange_pen" );
						game:Set( "got_permit_signed", 1 );
						flo:StartProc(signed_need_stamp);
					else
						flo:StartProc(call_colin);
					end
				else
					flo:StartProc(colin_ignores);
				end
			elseif item == "permit" then
				if game:Get( "called_colin" ) > 0 then
					flo:StartProc(no_pen_no_sign);
				else
					flo:StartProc(colin_ignores);
				end
			else
				flo:StartProc(colin_still_talking);
			end
		else
			flo:StartProc(colin_still_talking);
		end
	end;
};

function get_orange_pen(flo)
	flo:SetMode(MODE.CUTSCENE);
	game:Set( "found_orange_pen", 1 );
	run_super_conversation(flo, "quip_pickup_pen");
	scene.ORANGE_PEN:Expire();
	addInventory( inv_desc_orange_pen );
	flo:SetMode(MODE.FOLLOWCLICKS);
end;

orange_pen_spec =
{
	name = "ORANGE_PEN";
	halo = "pen";
	gfx = { image = "pen" };
	
	command = function(actor)
		actor:SetDepthValue(505);
	end;
	
	on_arrive = function(flo, pen)
		flo:StartProc(get_orange_pen);
	end;	
};

function gotolanding50(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	flo:WalkTo("flo");
	wait_walkto();
	goto_scene(flo, "m3_landing50");
end

exit_spec = 
{
	name = "EXIT";
	halo = "exit";
	cursor = "cursor_arrow_e";
	goto_fn = gotolanding50;
};

window_spec =
{
	name = "WINDOW";
	halo = "window";
	
	on_arrive = function(flo, window)
		flo:StartProc(great_view);	
	end;
};

phone_spec =
{
	name = "PHONE";
	halo = "phone";
	--gfx = { image = "phone" };
	
	command = function(actor)
		actor:SetDepthValue(430);
	end;
	
	on_arrive = function(flo, phone)
		game:Set( "clicked_on_phone", 1 );
		if ( game:Get( "called_colin" ) > 0 ) then
			flo:StartProc(already_called);
		else
			flo:StartProc(should_call);			
		end
	end;
};

permit_spec = 
{
	name = "PERMIT";
	
	gfx = { image = "permit" };
	
	command = function(actor)
		actor:SetDepthValue(425);
	end;
};

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/music_big_corp.ogg", true);
		scene:SetRoomScale(300, 550, 0.7, 1.1);	--topline, bottomline, topscale, bottomscale
		
		fade_scene_up();
		
		if IsCheatMode() then
			--BAG_INV:AddInventory(inv_desc_permit);
		end
		
		game:Set( "visited_signatures_office", 1 );
		
		if game:Get("given_colin_permit") > 0 and game:Get("got_permit_signed") < 1 then
			scene:Spawn(permit_spec);
		end
		
		if game:Get( "found_orange_pen" ) < 1 then
			scene:Spawn(orange_pen_spec);
		end
		
		spawn_nav_arrow(exit_spec);
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces" -- load pieces
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		{ "counter", 425 },
		{ "phone_and_pens", 427 },
		{ "left_front_chair", 500 },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		phone_spec,
		window_spec,
		
		colin_spec,
		
		flo_spec,
		
		scene_setup,
	};
};
